//
//  UKNibOwner.m
//  CocoaTADS
//
//  Created by Uli Kusterer on 13.11.04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import "UKNibOwner.h"


@implementation UKNibOwner

-(id)	init
{
	if( self = [super init] )
	{
		topLevelObjects = [[NSMutableArray alloc] init];
		NSDictionary*	ent = [NSDictionary dictionaryWithObjectsAndKeys:
									self, @"NSOwner",
									topLevelObjects, @"NSTopLevelObjects",
									nil];
		NSBundle*		mainB = [NSBundle mainBundle];
		[mainB loadNibFile: [self nibFilename]
							externalNameTable: ent withZone: [self zone]];	// We're responsible for releasing the top-level objects in the NIB (our view, right now).
		if( [topLevelObjects count] == 0 )
		{
			NSLog(@"%@: Couldn't find NIB file \"%@.nib\".", NSStringFromClass([self class]),[self nibFilename]);
			[self autorelease];
			return nil;
		}
	}
	
	return self;
}


-(void)	dealloc
{
	[topLevelObjects makeObjectsPerformSelector: @selector(release)];
	[topLevelObjects release];
	topLevelObjects = nil;
	
	[super dealloc];
}



-(NSString*)    nibFilename
{
    return NSStringFromClass([self class]);
}

@end
